class AdvancedUserRecipe1275798572(BasicNewsRecipe):
    title          = u'CBC Canada'
    publisher             = 'www.cbc.ca'
    language = 'en_CA'
    __author__ = 'rty'
    category              = 'news'
    oldest_article = 7
    max_articles_per_feed = 200
    remove_javascript = True
    use_embedded_content   = False
    no_stylesheets = True
    language = 'en'
    masthead_url = 'http://www.cbc.ca/includes/gfx/cbcnews_logo_09.gif'
    cover_url = 'http://img692.imageshack.us/img692/2814/cbc.png'

    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    keep_only_tags = [dict(name='div', attrs={'id':['storyhead','storybody']})]
    remove_tags_after  = dict(id=['socialtools'])

    remove_tags = [dict(name='div', attrs={'class':['','']}),
                            dict(name='div', attrs={'id':['tpSwf','',]}),
	        dict(name='span', attrs={'class':['photo left']}),
	        dict(name='h4', attrs={'class':['lastupdated']}),
	        dict(name='h5', attrs={'class':['byline']}),
	        dict(name='h3', attrs={'class':['deck']}),
                            dict(name=['img','br']),]
                                   
    feeds          = [(u'World', u'http://rss.cbc.ca/lineup/world.xml'),
                          (u'National', u'http://rss.cbc.ca/lineup/canada.xml'),
                          (u'Calgary', u'http://rss.cbc.ca/lineup/canada-calgary.xml'),
                          (u'Health', u'http://rss.cbc.ca/lineup/health.xml'),
                          (u'Music', u'http://rss.cbc.ca/lineup/arts-music.xml'),
                          (u'Film', u'http://rss.cbc.ca/lineup/arts-film.xml'),
                          (u'Tech & Science', u'http://rss.cbc.ca/lineup/technology.xml'),
                          (u'National In Depth', u'http://rss.cbc.ca/lineup/thenational.xml'),
                          (u'Wendy Mesley', u'http://www.cbc.ca/thenational/indepthanalysis/wendymesley/atom.xml')
                          ]


    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup

    def parse_feeds (self): 
      feeds = BasicNewsRecipe.parse_feeds(self) 
      for feed in feeds:
        for article in feed.articles[:]:
          print 'article.title is: ', article.title
          if 'GALLERY' in article.title.upper():
            feed.articles.remove(article)
          elif 'VIDEO' in article.url.upper():
            feed.articles.remove(article)
      return feeds